--> pralable
-- USE BD_Air_France;

-- Fonctions caractres 

CREATE TABLE T_pilote_pil
 (pil_brevet VARCHAR(6),pil_prenom VARCHAR(15),
  pil_nom VARCHAR(15), pil_surnom VARCHAR(10), cmp_compa VARCHAR(4),
  pil_hvol DECIMAL(7,2),pil_mail VARCHAR(20),pil_tel VARCHAR(15),
  CONSTRAINT PK_pil PRIMARY KEY(pil_brevet));
GO

INSERT INTO T_pilote_pil VALUES 
('PL-1', 'Pierre','Filloux', 'dba',
'AF',12000,'pf@free.fr','06-78-23-58-56');

INSERT INTO T_pilote_pil VALUES 
('PL-2', 'Christian','Sigaudes', 'smith', 'AF',9300,'sigaudes@orange.fr','06-83-22-67-13');

INSERT INTO T_pilote_pil VALUES 
('PL-3', 'Pierre','Perez', 'Faucon','SING',8400,NULL,NULL);

INSERT INTO T_pilote_pil VALUES 
('PL-4', 'Romaric','Benech', 'cool','CAST',4700,'rbenech@yahoo.fr',NULL);

INSERT INTO T_pilote_pil VALUES 
('PL-5', 'Vincent','Gindre', 'jone','SING',5200,NULL,NULL);

INSERT INTO T_pilote_pil VALUES 
('PL-6', 'Bruno','Duffau', 'actmp','CAST',
  8200, NULL,'06-24-61-35-60');


SELECT ASCII('A');

SELECT CHAR(161);

SELECT CHARINDEX ('air','Aibus 320 aircrafts on the air' 
                        COLLATE Latin1_General_CS_AS, 1);

SELECT CONCAT(CONCAT(pil_nom,' travaille pour '),cmp_compa) "Personnel" 
FROM   T_pilote_pil
WHERE  pil_brevet = 'PL-6';

SELECT DIFFERENCE('rbus','airbus'),DIFFERENCE('bayrou','mlenchon');

SELECT LEFT('A380  BlagnacB747B747',14) AS "Adieu Jumbo";

SELECT LEN('AF6143  ') AS "Taille";

SELECT LOWER('USA lE PaYS DEs CIRrus');

SELECT CONCAT(LTRIM('  AF6145 '),'15:45')      AS "Horaire";

SELECT NCHAR(31437) AS "Idogramme"; 

SELECT PATINDEX('%air%','Infos-air : airbus') AS "1er indice de 'air'";

SELECT REPLACE('...@iut-blagnac.fr, www.iut-blagnac.fr','iut-blagnac','univ-tlse2') 
       AS "L'IUT est maintenant dans la fac.";

SELECT REPLICATE ('sql-',5); 

SELECT REVERSE('cangalB  083A') AS "Miroir de gros porteur";

SELECT RIGHT('B747B747A380',4) AS "Sans les boeings";

SELECT CONCAT(RTRIM('AF6145         '),' 15:45') AS "Horaire";

SELECT pil_prenom, pil_nom, pil_surnom
FROM   T_pilote_pil 
WHERE  SOUNDEX(pil_surnom) IN (SOUNDEX('SMYTHE'), SOUNDEX('John'));

SELECT CONCAT('AF6143',CONCAT(SPACE(1),'8:15')) AS "Horaire";

SELECT STR(1523.445,7,2) AS "chane";

SELECT STUFF('www.et2.com',6,2,'yrolles') AS "URL";

SELECT SUBSTRING('Air France  Blagnac banane!',12,9) AS "Lieu";

SELECT UNICODE(N'') AS "A du nord";

SELECT UPPER(pil_prenom),UPPER(pil_nom)
FROM   T_pilote_pil
WHERE  pil_brevet = 'PL-1';

--  Numriques

SELECT CEILING(15.7);

SELECT COS(60*PI()/180) ;

SELECT DEGREES(PI()/2);

SELECT LOG(EXP(5));

SELECT POWER(2,5);

SELECT FLOOR(RAND()*40);

SELECT ROUND(17.567,2);

SELECT SIN(30*3.14159265359/180);

SELECT SIN(30*PI()/180);

-- bits

SELECT 4 | 12;

SELECT 4 & 12;

SELECT 4 ^ 12;
 
SELECT 3 << 2;
      
SELECT 3&(~3+1) ;

--- fonctions diverses

-- CHOOSE

SELECT SYSDATETIME(), 
     CHOOSE(MONTH(SYSDATETIME()),
 'Hiver','Hiver','Printemps','Printemps','Printemps','Ete','Ete',
 'Ete','Automne','Automne','Automne','Hiver') AS Saison_estimee

-- IIF

SELECT   pil_nom, IIF(pil_mail IS NULL, 'pas de mail',pil_mail)
FROM     T_pilote_pil;


-- Simple CASE expression

SELECT   pil_prenom,pil_nom, (
         CASE cmp_compa
           WHEN 'AF'   THEN 'Air France'
           WHEN 'CAST' THEN 'Castanet Air'
           ELSE             'Autre'
         END) AS "compagnie"
FROM     T_pilote_pil;

-- Searched CASE expression:

SELECT pil_prenom,pil_nom,
       (CASE 
         WHEN pil_hvol < 500                         THEN 'Novice'
         WHEN pil_hvol >= 5000 AND  pil_hvol < 10000 THEN 'Confirm'
         WHEN pil_hvol >= 10000                      THEN 'Expert'
         ELSE 'Standard') AS "Niveau"
      END
FROM  T_pilote_pil
ORDER BY 3;

-- CHECKSUM 

SELECT COALESCE(NULL,0,NULL*NULL,'B');

DECLARE @ch VARCHAR(100);
SELECT  @ch = COALESCE(@ch,'-') + pil_surnom + ';' 
FROM    T_pilote_pil
WHERE   cmp_compa IN ('AF', 'CAST'); 
SELECT @ch;

-- ISNULL ( check_expression , replacement_value )

SELECT   pil_brevet,ISNULL(pil_mail,'Inconnue') AS "naissance"
FROM     T_pilote_pil;

-- NULLIF ( expression , expression ) 

SELECT   pil_brevet,pil_nom ,NULLIF(pil_tel,pil_mail) AS "Ni tel ni E-mail"
FROM     T_pilote_pil
WHERE    NOT cmp_compa = 'AF';

DROP TABLE T_pilote_pil;
GO

-- Dates

SELECT SYSDATETIME()       AS "maintenant",
       SYSDATETIMEOFFSET() AS "decalage_greenwich",
       SYSUTCDATETIME()    AS "maintenant_TU";

SELECT CURRENT_TIMESTAMP AS "maintenant",
       GETDATE()         AS "maintenant",
       GETUTCDATE()      AS "maintenant_TU";

-- ISO


USE BD_Air_France;

IF OBJECT_ID ('dbo.T_vols_historique_vlh','U') IS NOT NULL
    DROP TABLE dbo.T_vols_historique_vlh;
GO
CREATE TABLE T_vols_historique_vlh
(vlh_num_vol  VARCHAR(8),
 vlh_creation         DATE       NOT NULL,
 vlh_fin_exploitation DATETIME2,
 vlh_h_dep            TIME(0),
 vlh_h_arr            TIME(0),
 aer_dep              VARCHAR(3) NOT NULL,
 aer_arr              VARCHAR(3) NOT NULL,
 CONSTRAINT  PK_vlh         PRIMARY KEY(vlh_num_vol,vlh_creation));
GO

INSERT INTO T_vols_historique_vlh
 (vlh_num_vol,vlh_creation,vlh_fin_exploitation,vlh_h_dep,vlh_h_arr,aer_dep,aer_arr)
VALUES 
 ('AF6140','19651025','19981220 15:45:00','12:35:00','13:55:00','TLS','ORY');


--

SELECT CAST('490420' AS DATETIME2)     AS "Siecle en cours",
       CAST('490212' AS SMALLDATETIME) AS "Siecle en cours",
       CAST('791124' AS DATE)          AS "Siecle pass",
       CAST('500420' AS DATETIME2)     AS "Siecle pass";

/* pour changer le sicle

USE master;
EXEC sp_configure 'show advanced option', '1';
RECONFIGURE;
GO
EXEC sp_configure 'two digit year cutoff', '2249';
RECONFIGURE;
GO

-- liste les paramtres
USE master;
EXEC sp_configure;

*/

-- construire des dates

-- Format date

USE master;
EXEC sp_helplanguage;

SELECT CAST('15/02/2005 12:32:10.00 +01:00' AS DATETIMEOFFSET) AS "DATETIMEOFFSET",
       CAST('15/02/2005' AS DATETIME2) AS "DATETIME2",
       CAST('15-02-2005' AS SMALLDATETIME) AS "SMALLDATETIME",
       CAST('15.02.2005' AS DATE) AS "DATE";

USE BD_Air_France;

INSERT INTO T_vols_historique_vlh
(vlh_num_vol,vlh_creation,vlh_fin_exploitation,vlh_h_dep,vlh_h_arr,aer_dep,aer_arr)
VALUES 
 ('AF6145','15/02/1995','15-02-2005 15:00:00','12:30:00','13:45:00','TLS','CDG');

-- SET DATEFORMAT

SET DATEFORMAT dmy;
GO

--1 passe pas
--DECLARE @datevar datetime2 = '05/13/1995 09:01:01.1234567';
--SELECT @datevar;

--2 passe
SELECT CAST('1995/05/13' AS DATETIME2) AS "13 Mai 1995";

--3 passe pas
--SELECT CAST('1995/13/05' AS DATETIME2) AS "13 Mai 1995";

--4 passe pas
--SELECT CAST('12/25/1995' AS DATETIME2) AS "25 Dec 1995";


USE BD_Air_France;
SET DATEFORMAT MDY;

INSERT INTO T_vols_historique_vlh
(vlh_num_vol,vlh_creation,vlh_fin_exploitation,vlh_h_dep,vlh_h_arr,aer_dep,aer_arr)
VALUES 
 ('AF6147','05/13/1995','07/27/2006 21:30:00','20:30:00','21:45:00','NIC','CDG');

/*
SELECT CAST('02/15/2005' AS DATETIME2);
Msg241, Niveau16, tat1, Ligne3
chec de la conversion de la date et/ou de l'heure  partir d'une chane de caractres.
*/

-- format interne

SELECT CONVERT(VARBINARY(MAX), CAST('2012/05/06' AS DATETIME2)) AS "Dbut de la journe...",
       CONVERT(VARBINARY(MAX), CAST('2012/05/06 20:00:00' AS DATETIME2)) AS "Le prsident est...";

-- bidouilles 

SELECT CAST(CAST('1753-01-01 12:00:00' AS DATETIME) AS FLOAT);

-- 1 Fevrier 1900  midi (31 jours et demi depuis le 1/1/1900, valu 0 en DATETIME)
SELECT CAST(CAST('1900-01-02 12:00:00' AS DATETIME) AS FLOAT);

-- 1 Fevrier 1900  midi (31 jours et demi depuis le 1/1/1900, valu 0 en DATETIME)
SELECT CAST(CAST('1900-01-02 12:00:00' AS DATETIME) AS FLOAT);

-- on ajoute 1 jour, 1h et 15 minutes (1.0 + 1/24.0 + 15/1440.0)
SELECT CAST((90.5+1.0+1/24.0+15/1440.0) AS DATETIME);

/*
SELECT CAST(CAST('1900-01-04 12:00:00' AS DATETIME2) AS FLOAT);
Msg529, Niveau16, tat2, Ligne6
La conversion explicite du type de donnes datetime2 en float n'est pas autorise.
*/

SELECT DAY  (GETDATE()) AS "Jour",
       MONTH(GETDATE()) AS "Mois",
       YEAR (GETDATE()) AS "Anne"

USE BD_Air_France;

SELECT  DAY(vlh_creation) AS "Jour",MONTH(vlh_creation) AS "Mois",YEAR(vlh_creation) AS "Anne"
FROM    T_vols_historique_vlh
WHERE   vlh_num_vol = 'AF6145';

SELECT  vlh_num_vol, YEAR(vlh_fin_exploitation) AS "Anne fin exploitation"
FROM    T_vols_historique_vlh
WHERE   YEAR(vlh_fin_exploitation) < 2006;


--- constructeurs
 
SELECT DATEFROMPARTS          (1965,02,05),
       SMALLDATETIMEFROMPARTS (1965,02,05,6,30),
       DATETIME2FROMPARTS     (1965,02,05,6,30,0,1276,4),
       DATETIMEOFFSETFROMPARTS(1965,02,05,6,30,0,1276,+1,0,4);


USE    BD_Air_France;
SELECT DATEFROMPARTS          (1965,02,05)                    AS dat_d1,
       SMALLDATETIMEFROMPARTS (1965,02,05,6,30)               AS dat_d2,
       DATETIME2FROMPARTS     (1965,02,05,6,30,0,1276,4)      AS dat_d3,
       DATETIMEOFFSETFROMPARTS(1965,02,05,6,30,0,1276,+1,0,4) AS dat_d4
INTO   T_date_naissance_dat;

DROP TABLE T_date_naissance_dat;

-- parties

-- DATENAME

SELECT
DATENAME(year,SYSDATETIME()) AS "Anne",
DATENAME(quarter,SYSDATETIME()) AS "Trimestre",
DATENAME(month,SYSDATETIME())  AS "Mois",
DATENAME(dayofyear,SYSDATETIME()) AS "Jour anne",
DATENAME(day,SYSDATETIME()) AS "Jour",
DATENAME(ISO_WEEK,SYSDATETIME()) AS "Semaine",
DATENAME(weekday,SYSDATETIME())  AS "Jour de semaine";

SELECT
DATENAME(hour,SYSDATETIME()) AS "Heure",
DATENAME(minute,SYSDATETIME()) AS "Minute",
DATENAME(second,SYSDATETIME()) AS "Seconde",
DATENAME(millisecond,SYSDATETIME()) AS "Mili seconde",
DATENAME(microsecond, SYSDATETIME()) AS "Micro seconde",
DATENAME(nanosecond, SYSDATETIME()) AS "Nano seconde";

SELECT
DATENAME(hour,SYSDATETIME()) AS "Heure",
DATENAME(minute,SYSDATETIME()) AS "Minute",
DATENAME(second,SYSDATETIME()) AS "Seconde",
DATENAME(millisecond,SYSDATETIME()) AS "Mili seconde",
DATENAME(microsecond, SYSDATETIME()) AS "Micro seconde",
DATENAME(nanosecond, SYSDATETIME()) AS "Nano seconde"
INTO T_le_changement_c_maintenant;

DROP TABLE T_le_changement_c_maintenant;

-- les journes et mois de dbut d'exploitation

USE    BD_Air_France;
SELECT vlh_num_vol, 
       DATENAME(weekday,vlh_creation) AS "Jour dbut exploitation",
       DATENAME(month,vlh_creation)   AS "Mois dbut exploitation",
	   vlh_creation
FROM   T_vols_historique_vlh;

SET DATEFORMAT YDM;
-- SELECT DATENAME(month,'2009/15/02');
SELECT DATENAME(month,CAST('2009/15/02' AS SMALLDATETIME));

-- DATEPART ( datepart , date ) Returns an integer

SELECT DATEPART(year,SYSDATETIME()) AS "Anne",
DATEPART(quarter,SYSDATETIME()) AS "Trimestre",
DATEPART(month,SYSDATETIME())  AS "Mois",
DATEPART(dayofyear,SYSDATETIME()) AS "Jour anne",
DATEPART(day,SYSDATETIME()) AS "Jour",
DATEPART(ISO_WEEK,SYSDATETIME()) AS "Semaine",
DATEPART(weekday,SYSDATETIME())  AS "Jour de semaine";

-- fin exploitation 3eme et 4eme trimestre

USE     BD_Air_France;
SELECT  vlh_num_vol, vlh_creation, vlh_fin_exploitation
FROM    T_vols_historique_vlh
WHERE   DATEPART(quarter,vlh_fin_exploitation) > 2;

--  ajouter soustraire : DATEADD (datepart , number , date )
	
-- int de -2147483648  2147483647

-- fin exploitation + 1j 1h et 15 minutes 

USE     BD_Air_France;
SELECT  vlh_num_vol, vlh_creation, vlh_fin_exploitation,
        DATEADD(minute,15,(DATEADD(hour,1,DATEADD(day,1,vlh_fin_exploitation))))
FROM    T_vols_historique_vlh;

--

SELECT DATEADD(day,-2000,DATEADD(month,-200,DATEADD(year,-20,SYSDATETIME())))
       AS "20 ans 200 mois et 2000 jours avant maintenant";

-- dpassements

SELECT DATEADD(second,2147483647,SYSDATETIME());

/*
SELECT DATEADD(second,2147483648,SYSDATETIME());
Msg8115, Niveau16, tat2, Ligne4
Une erreur de dpassement arithmtique s'est produite lors de la conversion de expression en type de donnes int.

SELECT DATEADD(month,-24500, CAST('2012-05-13' AS DATETIME2));
---------------------------
Msg517, Niveau16, tat3, Ligne4
L'ajout d'une valeur  une colonne 'datetime2' a provoqu un dpassement de capacit.
*/

-- intervalles DATEDIFF ( datepart , startdate , enddate ) : int

-- intervalle entre cration et fin exploitation

USE      BD_Air_France;
SELECT   vlh_num_vol, vlh_creation, vlh_fin_exploitation,
         DATEDIFF(day,vlh_creation,vlh_fin_exploitation) AS "Nombre de jours"
FROM     T_vols_historique_vlh
ORDER BY 4;

-- trouver le nombre exact j, h min et sec entre 2 dates?

DECLARE @d1 DATETIME2;
DECLARE @d2 DATETIME2;

SET @d1 = '2012-10-10 01:18:58';
SET @d2 = '2012-10-14 03:10:01';

SELECT DATEDIFF(day   ,@d1,@d2) AS "j",       DATEDIFF(hour  ,@d1,@d2) AS "h",
       DATEDIFF(minute,@d1,@d2) AS "min",     DATEDIFF(second,@d1,@d2) AS "sec.";


-- d1 plus petite que d2

DECLARE @d1 DATETIME2;
DECLARE @d2 DATETIME2;

SET @d1 = '2012-10-10 01:18:58';
SET @d2 = '2012-10-14 03:10:01';

-- SET @d1 = '1965-05-02 06:29:58';
-- SET @d2 = (SELECT GETDATE());

SELECT  DATEDIFF(second,@d1,@d2)                           AS "difference en secondes",
        DATEDIFF(second,@d1,@d2)/(24*60*60)                AS "jours",
        (DATEDIFF(second,@d1,@d2)%(24*60*60))/(60*60)      AS "heures",
        ((DATEDIFF(second,@d1,@d2)%(24*60*60))%(60*60))/60 AS "minutes",
        ((DATEDIFF(second,@d1,@d2)%(24*60*60))%(60*60))%60 AS "secondes";

-------  352 263  =  4 * 24*60*60 (345 600) +  1 * 60*60 (3600)  + 51 * 60 (3060) +  3 (3)
     

-- heures

USE    BD_Air_France;
SELECT TIMEFROMPARTS (15,54,23,0,0)  AS heu_t1,
       TIMEFROMPARTS (15,54,23,1,2)  AS heu_t2,
       TIMEFROMPARTS (15,54,23,78,4) AS heu_t3
INTO   T_heures_heu;

-- ajout d'heures

SELECT *
FROM   T_heures_heu;

SELECT heu_t1,
       DATEADD(hour,10,heu_t1)      AS "+ 10 heures",
       DATEADD(minute,214,heu_t1)   AS "+ 214 minutes (3 h. 34 min.)",
       DATEADD(second,18337,heu_t1) AS "+ 18337 secondes (5 h. 5 min. 37 sec.)"
FROM   T_heures_heu;

-- soustraire des heures

SELECT heu_t1,
       DATEADD(hour,-10,heu_t1)      AS "- 10 heures",
       DATEADD(minute,-214,heu_t1)   AS "- 214 minutes (3 h. 34 min.)",
       DATEADD(second,-18337,heu_t1) AS "- 18337 secondes (5 h. 5 min. 37 sec.)"
FROM   T_heures_heu;

-- dure entre les vols diff

USE      BD_Air_France;
SELECT   vlh_num_vol AS "Vol", aer_dep AS "Dpart", aer_arr AS "Arrive",
         DATEDIFF(minute,vlh_h_dep,vlh_h_arr) AS "Temps du vol (min.)"
FROM     T_vols_historique_vlh;

-- mises  jour 

USE      BD_Air_France;
INSERT INTO T_vols_historique_vlh
(vlh_num_vol,vlh_creation,vlh_fin_exploitation,vlh_h_dep,vlh_h_arr,aer_dep,aer_arr)
VALUES 
 ('AF441',DATEFROMPARTS(1990,05,13),
          DATETIME2FROMPARTS(2010,12,28,10,45,0,0,0),
          TIMEFROMPARTS(23,30,0,0,0),TIMEFROMPARTS(6,0,0,0,0),'CDG','GIG');

UPDATE  T_vols_historique_vlh
SET     vlh_creation = DATEFROMPARTS(1990,04,10)
WHERE   vlh_num_vol  = 'AF441';

UPDATE  T_vols_historique_vlh
SET     vlh_fin_exploitation = DATEADD(month,3,vlh_fin_exploitation)
WHERE   vlh_num_vol          = 'AF6145';

UPDATE  T_vols_historique_vlh
SET     vlh_h_arr   = DATEADD(minute,-15,vlh_h_arr)
WHERE   vlh_num_vol = 'AF6140';


-- autres fct

SELECT EOMONTH(DATEFROMPARTS(2012,02,21)) AS 'Fvrier 2012',
       EOMONTH('2012-02-21 01:18:58',12)  AS 'Fvrier 2013',
       EOMONTH('20120221',          -12 ) AS 'Fvrier 2011';

DECLARE @d1 DATETIMEOFFSET;
SET     @d1 = DATETIMEOFFSETFROMPARTS(2014,02,05,7,33,45,0,+5,0,0);
SELECT  @d1 AS "Avant";
SET     @d1 = SWITCHOFFSET(@d1,'-01:00');
SELECT  @d1 AS "Aprs";	

DECLARE @d1   DATETIME2(3);
DECLARE @d2   DATETIMEOFFSET(3);
SET     @d1 = DATETIME2FROMPARTS (2012,12,05,6,30,0,276,3);
SELECT  @d1 AS "Avant";
SET     @d2 = TODATETIMEOFFSET(@d1,'+10:00');
SELECT  @d2 AS "Aprs";	

DECLARE @d1   DATE;
DECLARE @t1   TIME;
SET     @d1 = DATEFROMPARTS(2012,15,15);


SET    DATEFORMAT DMY;
SELECT ISDATE('13/05/1995') AS "13/05/1995", ISDATE('19950513') AS "19950513",
       ISDATE('2012/12/14') AS "2012/12/14", ISDATE('2012/14/14') AS "2012/14/14";

SET    DATEFORMAT YMD;
SELECT ISDATE('2012/12/14') AS "2012/12/14", ISDATE('2012/14/14') AS "2012/14/14";

SELECT ISDATE('20:30:59') AS "20:30:59",ISDATE('20:30:60') AS "20:30:60",
       ISDATE('0:0:0') AS "0:0:0",ISDATE('10:70:00') AS "10:70:00";

-- FORMAT 

DECLARE @d DATETIME2 = GETDATE();
SELECT FORMAT( @d,'d','en-US' ) AS "Date US",FORMAT( @d,'d','fr-FR' ) AS "Date FR";
SELECT FORMAT( @d,'dddd dd MMMM, yyyy hh \h. mm \min. ss \sec. fff \milli.') AS "Maintenant";

-- CAST CONVERT
         
     
-- CAST ( expression AS data_type [ ( length ) ] )

/*
SELECT CAST ('ABC' AS DECIMAL(10));
 Msg8114, Niveau16, tat5, Ligne3
Erreur de conversion du type de donnes varchar en numeric.
*/

/*
SELECT CAST ('ABC' AS INT);
Msg245, Niveau16, tat1, Ligne4
chec de la conversion de la valeur varchar 'ABC' en type de donnes int.
*/

-- explicites

SELECT CAST('ABC' AS BINARY(3)) AS " BINARY(3)", CAST ('ABC' AS VARBINARY) AS "VARBINARY";

SELECT CAST(CAST(GETDATE() AS SMALLDATETIME) AS VARBINARY) AS "VARBINARY";

SELECT CAST(1546.4 AS CHAR(4)) AS "CHAR(4)";

SELECT CAST('193.57' AS DECIMAL(5,2)) AS " DECIMAL(5,2)";

SELECT CAST('20120325' AS DATE) AS "DATE", CAST('20120325' AS SMALLDATETIME) AS "SMALLDATETIME",
       CAST('20120325' AS DATETIME2) AS "DATETIME2", 
       CAST('20120325' AS DATETIMEOFFSET) AS "DATETIMEOFFSET";

SELECT CAST(SYSDATETIMEOFFSET() AS CHAR(34)) AS "SYSDATETIMEOFFSET()";

/*
SELECT CAST('193.57' AS DECIMAL(4,2)) AS " DECIMAL(4,2)";
Msg8115, Niveau16, tat8, Ligne4
Une erreur de dpassement arithmtique s'est produite lors de la conversion de varchar en type de donnes numeric.
*/

SELECT CAST(CAST(SYSDATETIME() AS DATE) AS VARCHAR);
SELECT CAST(CAST(SYSDATETIME() AS SMALLDATETIME) AS VARCHAR);
SELECT CAST(CAST(SYSDATETIME() AS DATETIME2) AS VARCHAR);

-- CONVERT ( data_type [ ( length ) ] , expression [ , style ] )

DECLARE @f FLOAT;
SET     @f = 193445.574 / PI();
SELECT CONVERT(VARCHAR,@f,0) AS "Rel style 0",
       CONVERT(VARCHAR,@f,1) AS "Rel style 1",
       CONVERT(VARCHAR,@f,2) AS "Rel style 2";

--
   
DECLARE @s SMALLMONEY;
SET     @s = 214748.3647;

SELECT CONVERT(VARCHAR,@s,0) AS "SMALLMONEY style 0",
       CONVERT(VARCHAR,@s,1) AS "SMALLMONEY style 1",
       CONVERT(VARCHAR,@s,2) AS "SMALLMONEY style 2";

--

SELECT CONVERT(VARCHAR,GETDATE(),0) AS "Par dfaut", 
       CONVERT(VARCHAR,GETDATE(), 113) AS "Europe";

SELECT CONVERT(VARCHAR,GETDATE(),3)  AS "French sans sicle" ,
       CONVERT(VARCHAR,GETDATE(),103) AS "French avec sicle";

SELECT  CONVERT(VARCHAR,GETDATE(), 112) AS "ISO",
      CONVERT(VARCHAR,GETDATE(), 126) AS "ISO8601";

-- CAST and CONVERT  

DECLARE @d1 CHAR(8), @t1 INT;
SET     @d1 = '20120425';
SET     @t1 = 114926;
SELECT CONVERT(VARCHAR, CAST(@d1 AS DATE), 113)
      + ' ' + SUBSTRING(CAST (@t1 AS CHAR(6)),1,2)
      + ':' + SUBSTRING(CAST (@t1 AS CHAR(6)),3,2)
      + ':' + SUBSTRING(CAST (@t1 AS CHAR(6)),5,2);

-- conversions implicites

SELECT CAST(CAST(GETDATE() AS SMALLDATETIME) AS VARBINARY);
SELECT CAST(CAST(CAST(GETDATE() AS SMALLDATETIME) AS VARBINARY) AS INT);

-- collation French_CI_AS par dfaut

USE      BD_Air_France;

DROP TABLE T_conversions_cnv;

CREATE TABLE T_conversions_cnv
(cnv_varchar_8 VARCHAR(8) PRIMARY KEY,
 cnv_date      SMALLDATETIME,
 cnv_int       INT,
 cnv_float     FLOAT,
 cnv_decimal   DECIMAL(6,2));

INSERT INTO T_conversions_cnv
(cnv_varchar_8,cnv_date,cnv_int,cnv_float,   cnv_decimal) VALUES
(12345678,     26889,   '12345','12.34567E20','12.34567');

SELECT  * FROM    T_conversions_cnv WHERE   cnv_varchar_8 = 12345678;

SELECT  * FROM    T_conversions_cnv WHERE   cnv_varchar_8 = '12345678';

CREATE TABLE T_collations_col
(col_French_BIN VARCHAR(8) COLLATE French_BIN);

INSERT INTO T_collations_col VALUES ('cur');

SELECT  CONCAT(cnv.cnv_varchar_8,col.col_French_BIN)
FROM    T_collations_col col, T_conversions_cnv cnv;

/*
Msg468, Niveau16, tat9, Ligne5
Impossible de rsoudre le conflit de classement entre "French_CI_AS" et "French_BIN" dans l'opration concat.
*/

SELECT  CONCAT(CAST(cnv.cnv_decimal AS VARCHAR(8)) COLLATE French_BIN,col.col_French_BIN)
        AS "Concatnation"
FROM    T_collations_col col, T_conversions_cnv cnv;

DROP TABLE T_conversions_cnv;
DROP TABLE T_Collations_col;


-- PARSE TRY_CONVERT, TRY PARSE

SELECT PARSE('123,45' AS NUMERIC(8,2) using 'fr-FR') AS Decimal;
SELECT PARSE('27/09/2013' as DATE using 'fr-FR') AS Date_FR;
SELECT PARSE('Samedi 28 Septembre 2013' AS DATETIME2 USING 'fr-FR') AS Date_FR;


SELECT TRY_PARSE('10.1200' AS DECIMAL(6,4));
SELECT TRY_PARSE('100.1200' AS DECIMAL(6,4)) ;


SET LANGUAGE English;
SELECT TRY_PARSE('13/10/2014' AS datetime2)  AS Date_Ang,
       TRY_PARSE('13/10/2014' AS datetime2 USING 'fr-FR') AS Date_Fra;

SET DATEFORMAT ymd;
SELECT TRY_CONVERT(datetime2, '2014/12/30') AS Date_ymd;





/* GROUPEMENTS */


USE      BD_Air_France;
CREATE TABLE T_pilote_pil
 (pil_brevet VARCHAR(6),pil_prenom VARCHAR(15),
  pil_nom VARCHAR(15), pil_hvol DECIMAL(7,2), avi_typavi CHAR(4), 
  pil_prime DECIMAL(5,2), pil_embauche DATE, cmp_compa VARCHAR(4),
  CONSTRAINT PK_pil PRIMARY KEY(pil_brevet));

INSERT INTO T_pilote_pil VALUES ('PL-1','Pierre','Filloux'    ,450    ,'A320',500 ,DATEFROMPARTS(1985,06,22),'AF');
INSERT INTO T_pilote_pil VALUES ('PL-2','Christian','Sigaudes',8700.50,'A320',NULL,DATEFROMPARTS(1995,05,13),'AF');
INSERT INTO T_pilote_pil VALUES ('PL-3','Pierre','Perez'      ,5600,   'A320',NULL,DATEFROMPARTS(2001,09,12),'SING');
INSERT INTO T_pilote_pil VALUES ('PL-4','Romaric','Benech'    ,2450,   'A330',500 ,DATEFROMPARTS(2001,09,21),'CAST');
INSERT INTO T_pilote_pil VALUES ('PL-5','Vincent','Gindre'    ,5605,   'A340',600 ,DATEFROMPARTS(1995,01,16),'SING');
INSERT INTO T_pilote_pil VALUES ('PL-6','Bruno','Duffau'      ,NULL,   'A340',0   ,DATEFROMPARTS(2001,09,21),'CAST');

SELECT AVG(pil_hvol) AS "Moyenne heures", 
       AVG(pil_prime) AS "Moyenne primes", AVG(ISNULL(pil_prime,0)) AS "Moyenne primes nette"
FROM   T_pilote_pil 
WHERE  cmp_compa = 'AF';

SELECT  COUNT(*) AS "COUNT(*)",
        COUNT(cmp_compa)          AS "COUNT(cmp_compa)", 
        COUNT(DISTINCT cmp_compa) AS "COUNT(DISTINCT cmp_compa)"
FROM    T_pilote_pil ;

SELECT MAX(pil_hvol) AS "Max hvol", MAX(pil_embauche) "Embauche rcente", 
       MIN(pil_prime) AS "Min prime", MIN(pil_embauche) "Embauche ancienne" 
FROM   T_pilote_pil;

-- groupements simples

SELECT   cmp_compa AS "Compagnie", COUNT(pil_brevet) AS "Nb pilotes" 
FROM     T_pilote_pil
GROUP BY (cmp_compa);

SELECT   cmp_compa cp, COUNT(pil_brevet) nbp
FROM     T_pilote_pil
GROUP BY (cmp_compa);

/*
SELECT   cmp_compa cp, COUNT(pil_brevet) nbp
FROM     T_pilote_pil
GROUP BY (nbp);
Msg207, Niveau16, tat1, Ligne...Nom de colonne non valide: 'nbp'.
*/

SELECT   cmp_compa AS "Compagnie", COUNT(pil_brevet) AS "Nombre pilotes", 
         AVG(pil_hvol) AS "Moyenne heures", 
         SUM(ISNULL(pil_prime,0)) AS "Somme des primes"
FROM     T_pilote_pil 
GROUP BY cmp_compa;

/*
SELECT   cmp_compa, avi_typavi, COUNT(pil_brevet) 
FROM     T_pilote_pil 
GROUP BY cmp_compa;
Msg8120, Niveau16, tat1, Ligne6
La colonne 'T_pilote_pil.avi_typavi' n'est pas valide dans la liste de slection parce qu'elle n'est pas contenue dans une fonction d'agrgation ou dans la clause GROUP BY.
*/

SELECT   cmp_compa AS "Compagnie", avi_typavi AS "Avion", COUNT(pil_brevet) AS "Nombre pilotes" 
FROM     T_pilote_pil 
GROUP BY cmp_compa, avi_typavi;

SELECT   cmp_compa AS "Compagnie", avi_typavi AS "Avion", COUNT(pil_brevet) AS "Nombre pilotes" 
FROM     T_pilote_pil 
GROUP BY cmp_compa, avi_typavi
HAVING   COUNT(pil_brevet) > 1;

-- CHECKSUM_AGG ( [ ALL | DISTINCT ] expression )  

DROP TABLE T_pilote_pil;
DROP TABLE dbo.T_vols_historique_vlh;

-- Fonctions avances de groupe

USE      BD_Air_France;

CREATE TABLE T_qualifs_qlf
 (qlf_brevet VARCHAR(6), qlf_annee DECIMAL(4,0),
  avi_typavi VARCHAR(4), cmp_compa VARCHAR(4));

INSERT INTO T_qualifs_qlf VALUES ('PL-1',2009,'A320','AF');
INSERT INTO T_qualifs_qlf VALUES ('PL-1',2009,'A330','AF');
INSERT INTO T_qualifs_qlf VALUES ('PL-1',2009,'A340','AF');

INSERT INTO T_qualifs_qlf VALUES ('PL-1',2010,'A330','AF');
INSERT INTO T_qualifs_qlf VALUES ('PL-1',2010,'A340','AF');

INSERT INTO T_qualifs_qlf VALUES ('PL-1',2011,'A380','AF');
INSERT INTO T_qualifs_qlf VALUES ('PL-1',2011,'A330','AF');
INSERT INTO T_qualifs_qlf VALUES ('PL-1',2011,'A340','AF');

INSERT INTO T_qualifs_qlf VALUES ('PL-2',2009,'A320','AF');
INSERT INTO T_qualifs_qlf VALUES ('PL-2',2009,'A340','AF');

INSERT INTO T_qualifs_qlf VALUES ('PL-2',2010,'A320','AF');

INSERT INTO T_qualifs_qlf VALUES ('PL-2',2011,'A320','AF');

INSERT INTO T_qualifs_qlf VALUES ('PL-3',2009,'A320','EJ');
INSERT INTO T_qualifs_qlf VALUES ('PL-3',2009,'A330','EJ');

INSERT INTO T_qualifs_qlf VALUES ('PL-3',2010,'A330','EJ');
INSERT INTO T_qualifs_qlf VALUES ('PL-3',2010,'A340','EJ');

INSERT INTO T_qualifs_qlf VALUES ('PL-3',2011,'A380','EJ');

-- GROUP BY ROLLUP(expression[,...])

SELECT   avi_typavi,qlf_annee,COUNT(qlf_brevet)
FROM     T_qualifs_qlf
GROUP BY avi_typavi,qlf_annee;

SELECT   avi_typavi,qlf_annee,COUNT(qlf_brevet) AS "Pilotes"
FROM     T_qualifs_qlf
GROUP BY ROLLUP(avi_typavi,qlf_annee);

SELECT   cmp_compa,avi_typavi,qlf_annee,COUNT(qlf_brevet) AS "Pilotes"
FROM     T_qualifs_qlf
GROUP BY cmp_compa,avi_typavi,qlf_annee;

SELECT   cmp_compa,avi_typavi,qlf_annee,COUNT(qlf_brevet) AS "Pilotes"
FROM     T_qualifs_qlf
GROUP BY ROLLUP(cmp_compa,avi_typavi,qlf_annee);

-- cmp_compa,avi_typavi,qlf_annee / cmp_compa,avi_typavi / cmp_compa

SELECT   cmp_compa,avi_typavi,qlf_annee,COUNT(qlf_brevet)
FROM     T_qualifs_qlf
GROUP BY ROLLUP (cmp_compa,avi_typavi),ROLLUP(qlf_annee);

-- cmp_compa,avi_typavi,qlf_annee / cmp_compa,avi_typavi / cmp_compa,qlf_annee / cmp_compa
-- / qlf_annee

-- GROUP BY CUBE(expression [,...])

SELECT   cmp_compa,avi_typavi,COUNT(qlf_brevet) AS "Pilotes"
FROM     T_qualifs_qlf
GROUP BY CUBE(cmp_compa,avi_typavi);

SELECT   cmp_compa,avi_typavi,qlf_annee,COUNT(qlf_brevet) AS "Pilotes"
FROM     T_qualifs_qlf
GROUP BY CUBE(cmp_compa,avi_typavi,qlf_annee);

-- GROUP BY GROUPING SETS( CUBE(expression [,...])
-- GROUP BY GROUPING SETS( ROLLUP(expression[,...]))
-- GROUP BY GROUPING SETS( ())

SELECT   cmp_compa,avi_typavi,qlf_annee,COUNT(qlf_brevet) AS "Pilotes"
FROM     T_qualifs_qlf
GROUP BY GROUPING SETS((cmp_compa,avi_typavi),qlf_annee,());

-- limites


/*

SELECT   cmp_compa,avi_typavi,COUNT(qlf_brevet) AS "Pilotes"
FROM     T_qualifs_qlf
GROUP BY CUBE(cmp_compa,avi_typavi,cmp_compa,avi_typavi,
              cmp_compa,avi_typavi,cmp_compa,avi_typavi,
              cmp_compa,avi_typavi,cmp_compa,avi_typavi,avi_typavi);

*/

DROP TABLE T_qualifs_qlf;

-- Analytiques

USE      BD_Air_France;

CREATE TABLE T_qualifs_qlf
 (qlf_brevet VARCHAR(6), qlf_annee DECIMAL(4,0),
  avi_typavi VARCHAR(4), qlf_hvol  DECIMAL(5,2));

INSERT INTO T_qualifs_qlf VALUES ('PL-1',2009,'A320',200.50);
INSERT INTO T_qualifs_qlf VALUES ('PL-1',2009,'A330',300);
INSERT INTO T_qualifs_qlf VALUES ('PL-1',2009,'A340',158.50);

INSERT INTO T_qualifs_qlf VALUES ('PL-1',2010,'A330',456);
INSERT INTO T_qualifs_qlf VALUES ('PL-1',2010,'A340',251);

INSERT INTO T_qualifs_qlf VALUES ('PL-1',2011,'A380',169.20);
INSERT INTO T_qualifs_qlf VALUES ('PL-1',2011,'A330',450.30);
INSERT INTO T_qualifs_qlf VALUES ('PL-1',2011,'A340',148);

INSERT INTO T_qualifs_qlf VALUES ('PL-2',2009,'A320',500.30);
INSERT INTO T_qualifs_qlf VALUES ('PL-2',2009,'A340',120);

INSERT INTO T_qualifs_qlf VALUES ('PL-2',2010,'A320',780);

INSERT INTO T_qualifs_qlf VALUES ('PL-2',2011,'A320',520.50);

INSERT INTO T_qualifs_qlf VALUES ('PL-3',2009,'A320',600.20);
INSERT INTO T_qualifs_qlf VALUES ('PL-3',2009,'A330',100.50);

INSERT INTO T_qualifs_qlf VALUES ('PL-3',2010,'A330',150);
INSERT INTO T_qualifs_qlf VALUES ('PL-3',2010,'A340',200.60);

INSERT INTO T_qualifs_qlf VALUES ('PL-3',2011,'A380',290);


INSERT INTO T_qualifs_qlf VALUES ('PL-4',2007,'A380',90);

INSERT INTO T_qualifs_qlf VALUES ('PL-4',2009,'A380',800);
INSERT INTO T_qualifs_qlf VALUES ('PL-4',2009,'B777',200);

INSERT INTO T_qualifs_qlf VALUES ('PL-4',2011,'A380',900);

-- OVER

-- avec des fct agrgats

SELECT avi_typavi,qlf_annee,qlf_brevet
    ,SUM(qlf_hvol)     OVER(PARTITION BY avi_typavi,qlf_annee) AS "Total h"
    ,AVG(qlf_hvol)     OVER(PARTITION BY qlf_annee)  AS "Moyenne anne"
    ,AVG(qlf_hvol)     OVER(PARTITION BY avi_typavi,qlf_annee)  AS "Moyenne anne/avion"
	,COUNT(qlf_brevet) OVER(PARTITION BY avi_typavi,qlf_annee) AS "Pilotes"
    ,MIN(qlf_hvol)     OVER(PARTITION BY avi_typavi) AS "Min"
    ,MAX(qlf_hvol)     OVER(PARTITION BY avi_typavi) AS "Max"
FROM T_qualifs_qlf;


-- Ranking 

SELECT ROW_NUMBER() 
      OVER(PARTITION BY avi_typavi ORDER BY qlf_annee DESC) AS "ROW_NUMBER()",
     qlf_brevet,avi_typavi,qlf_annee
FROM T_qualifs_qlf;

SELECT RANK()
      OVER(PARTITION BY avi_typavi ORDER BY qlf_annee DESC) AS "RANK()",
      qlf_brevet,avi_typavi,qlf_annee
FROM  T_qualifs_qlf
WHERE avi_typavi = 'A380';

SELECT DENSERANK()
      OVER(PARTITION BY avi_typavi ORDER BY qlf_annee DESC) AS "DENSERANK()",
     qlf_brevet,avi_typavi,qlf_annee
FROM T_qualifs_qlf
WHERE avi_typavi = 'A380';

SELECT NTILE(4) 
      OVER(ORDER BY avi_typavi,qlf_hvol DESC) AS "NTILE",
     qlf_brevet,avi_typavi,qlf_hvol,qlf_annee
FROM T_qualifs_qlf;

SELECT TOP(3) WITH TIES
 RANK() OVER(PARTITION BY avi_typavi ORDER BY qlf_annee DESC) AS rang,
     qlf_brevet,avi_typavi,qlf_annee
FROM T_qualifs_qlf
ORDER BY rang;

-- analytiques

-- Valeur suivante dans le dataset :

SELECT 
       qlf_brevet,qlf_annee,avi_typavi,qlf_hvol,
       LEAD (qlf_hvol,1,0) OVER (PARTITION BY qlf_brevet,avi_typavi ORDER BY qlf_annee) AS "an+1",
       LEAD (qlf_hvol,2,0) OVER (PARTITION BY qlf_brevet,avi_typavi ORDER BY qlf_annee) AS "an+2"
FROM   T_qualifs_qlf;

/*
WHERE  NOT (
       LEAD (qlf_hvol,1,0) OVER (PARTITION BY qlf_brevet,avi_typavi ORDER BY qlf_annee) = 0
AND    LEAD (qlf_hvol,2,0) OVER (PARTITION BY qlf_brevet,avi_typavi ORDER BY qlf_annee) = 0);

--> SELECT dans le FROM pour anuller certains
WHERE  NOT (hvol1 = 0 AND hvol2 = 0);
*/


-- Valeur prcdente dans le dataset :

SELECT 
       qlf_brevet,qlf_annee,avi_typavi,qlf_hvol,
       LAG(qlf_hvol,1,0) OVER (PARTITION BY qlf_brevet,avi_typavi ORDER BY qlf_annee ASC) AS "an-1",
       LAG(qlf_hvol,2,0) OVER (PARTITION BY qlf_brevet,avi_typavi ORDER BY qlf_annee ASC) AS "an-2"
FROM   T_qualifs_qlf;

-- Premire valeur dans un dataset

SELECT 
     DISTINCT qlf_brevet,avi_typavi,
     FIRST_VALUE(qlf_annee) OVER (PARTITION BY qlf_brevet,avi_typavi ORDER BY qlf_hvol) AS "Anne +faible",
     FIRST_VALUE(qlf_hvol) OVER (PARTITION BY qlf_brevet,avi_typavi ORDER BY qlf_hvol) AS "Heure vol"
FROM   T_qualifs_qlf;

-- dernire valeur dans un dataset

SELECT 
     DISTINCT qlf_brevet,avi_typavi,
     LAST_VALUE(qlf_annee)  
          OVER (PARTITION BY qlf_brevet,avi_typavi ORDER BY qlf_hvol 
                RANGE BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS "Anne +forte",
     LAST_VALUE(qlf_hvol)  
          OVER (PARTITION BY qlf_brevet,avi_typavi ORDER BY qlf_hvol
                RANGE BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS "Heure vol"
FROM   T_qualifs_qlf;

-- Partie de cumul de dataset

SELECT 
     qlf_brevet,avi_typavi,qlf_annee,qlf_hvol,
     CUME_DIST() OVER(PARTITION BY avi_typavi ORDER BY qlf_hvol) AS "CUME_DIST"
FROM   T_qualifs_qlf
ORDER BY 5 DESC;


--INTERSECT 

SELECT   qlf_brevet FROM T_qualifs_qlf WHERE avi_typavi='A320'
INTERSECT 
SELECT   qlf_brevet FROM T_qualifs_qlf WHERE avi_typavi='A340';


SELECT   qlf_brevet FROM T_qualifs_qlf 
WHERE avi_typavi='A320' AND qlf_annee = 2009
INTERSECT 
SELECT   qlf_brevet FROM T_qualifs_qlf WHERE avi_typavi='A340'
AND qlf_annee = 2009;


DROP TABLE T_qualifs_qlf; 

DROP TABLE T_pilote_pil;
GO
